﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private appSettings As JotAppSettings = (TryCast(Application.Current, App)).AppSettings
    Private activeStrokes As New Dictionary(Of Integer, Stroke)()


    Public Sub New()
        InitializeComponent()

        inkPresenter.Strokes = appSettings.StrokeCollections(appSettings.PageNumber)
        inkPresenter.Background = New SolidColorBrush(appSettings.Background)

        ' Re-assign ApplicationBar button names
        appbarLastButton = TryCast(Me.ApplicationBar.Buttons(1), ApplicationBarIconButton)
        appbarNextButton = TryCast(Me.ApplicationBar.Buttons(2), ApplicationBarIconButton)
        appbarDeleteButton = TryCast(Me.ApplicationBar.Buttons(3), ApplicationBarIconButton)

        TitleAndAppbarUpdate()

        AddHandler Touch.FrameReported, AddressOf OnTouchFrameReported
    End Sub


    Private Sub OnTouchFrameReported(ByVal sender As Object, ByVal args As TouchFrameEventArgs)
        Dim primaryTouchPoint = args.GetPrimaryTouchPoint(Nothing)

        If primaryTouchPoint IsNot Nothing AndAlso primaryTouchPoint.Action = TouchAction.Down Then
            args.SuspendMousePromotionUntilTouchUp()
        End If

        Dim touchPoints = args.GetTouchPoints(inkPresenter)

        For Each touchPoint In touchPoints
            Dim pt = touchPoint.Position
            Dim id = touchPoint.TouchDevice.Id

            Select Case touchPoint.Action
                Case TouchAction.Down
                    Dim stroke As New Stroke()
                    stroke.DrawingAttributes.Color = appSettings.Foreground
                    stroke.DrawingAttributes.Height = appSettings.StrokeWidth
                    stroke.DrawingAttributes.Width = appSettings.StrokeWidth
                    stroke.StylusPoints.Add(New StylusPoint(pt.X, pt.Y))

                    inkPresenter.Strokes.Add(stroke)
                    activeStrokes.Add(id, stroke)

                Case TouchAction.Move
                    activeStrokes(id).StylusPoints.Add(New StylusPoint(pt.X, pt.Y))

                Case TouchAction.Up
                    activeStrokes(id).StylusPoints.Add(New StylusPoint(pt.X, pt.Y))
                    activeStrokes.Remove(id)

                    TitleAndAppbarUpdate()
            End Select
        Next touchPoint
    End Sub


    Private Sub OnAppbarAddClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim strokes As New StrokeCollection()
        appSettings.PageNumber += 1
        appSettings.StrokeCollections.Insert(appSettings.PageNumber, strokes)
        inkPresenter.Strokes = strokes
        TitleAndAppbarUpdate()
    End Sub


    Private Sub OnAppbarLastClick(ByVal sender As Object, ByVal args As EventArgs)
        appSettings.PageNumber -= 1
        inkPresenter.Strokes = appSettings.StrokeCollections(appSettings.PageNumber)
        TitleAndAppbarUpdate()
    End Sub


    Private Sub OnAppbarNextClick(ByVal sender As Object, ByVal args As EventArgs)
        appSettings.PageNumber += 1
        inkPresenter.Strokes = appSettings.StrokeCollections(appSettings.PageNumber)
        TitleAndAppbarUpdate()
    End Sub


    Private Sub OnAppbarDeleteClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim result = MessageBox.Show("Delete this page?", "Jot", MessageBoxButton.OKCancel)

        If result = MessageBoxResult.OK Then
            If appSettings.StrokeCollections.Count = 1 Then
                appSettings.StrokeCollections(0).Clear()
            Else
                appSettings.StrokeCollections.RemoveAt(appSettings.PageNumber)

                If appSettings.PageNumber = appSettings.StrokeCollections.Count Then
                    appSettings.PageNumber -= 1
                End If

                inkPresenter.Strokes = appSettings.StrokeCollections(appSettings.PageNumber)
            End If
            TitleAndAppbarUpdate()
        End If
    End Sub


    Private Sub OnAppbarSwapColorsClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim foreground = appSettings.Background
        appSettings.Background = appSettings.Foreground
        appSettings.Foreground = foreground
        inkPresenter.Background = New SolidColorBrush(appSettings.Background)

        For Each strokeCollection In appSettings.StrokeCollections
            For Each stroke In strokeCollection
                stroke.DrawingAttributes.Color = appSettings.Foreground
            Next stroke
        Next strokeCollection
    End Sub


    Private Sub OnAppbarSetStrokeWidthClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim item = TryCast(sender, ApplicationBarMenuItem)

        If item.Text.StartsWith("light") Then
            appSettings.StrokeWidth = 1

        ElseIf item.Text.StartsWith("medium") Then
            appSettings.StrokeWidth = 3

        ElseIf item.Text.StartsWith("heavy") Then
            appSettings.StrokeWidth = 5
        End If
    End Sub


    Private Sub TitleAndAppbarUpdate()
        pageInfoTitle.Text = String.Format(" - PAGE {0} OF {1}",
                                           appSettings.PageNumber + 1,
                                           appSettings.StrokeCollections.Count)

        appbarLastButton.IsEnabled = appSettings.PageNumber > 0
        appbarNextButton.IsEnabled = appSettings.PageNumber < appSettings.StrokeCollections.Count - 1
        appbarDeleteButton.IsEnabled =
            (appSettings.StrokeCollections.Count > 1) OrElse (appSettings.StrokeCollections(0).Count > 0)
    End Sub
End Class